/*
 * Decompiled with CFR 0.152.
 */
package jpasswordrecoverytool;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jpasswordrecoverytool.AboutBox;
import jpasswordrecoverytool.ArchiveBruter;
import jpasswordrecoverytool.HashBruter;

public class BruterUI
extends JFrame {
    private static final int width = 800;
    private static final int height = 300;
    private static boolean isRunning = false;
    private boolean isShown = false;
    private boolean isPaused = false;
    private SystemTray tray;
    private TrayIcon trayIcon;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenu menuHelp;
    private static JMenuItem menuItemExit;
    private static JMenuItem menuItemAbout;
    private static JMenuItem menuItem7z;
    private static JMenuItem menuItemUpdate;
    Image icon7z = new ImageIcon("resources" + separtor + "7ziplogo.png").getImage().getScaledInstance(24, 24, 4);
    Image iconUpdate = new ImageIcon("resources" + separtor + "windows_update_icon.png").getImage().getScaledInstance(24, 24, 4);
    Image iconAbout = new ImageIcon("resources" + separtor + "About-icon.png").getImage().getScaledInstance(24, 24, 4);
    Image iconExit = new ImageIcon("resources" + separtor + "exit.png").getImage().getScaledInstance(24, 24, 4);
    private JPanel archiveRecoveryPanel;
    private JPanel archiveNorthJPanel;
    private JPanel archiveSouthJPanel;
    private JPanel archiveSouthInnerLeftJPanel;
    private JPanel archiveSouthInnerRightJPanel;
    private JTextArea archiveConsoleJTextArea;
    private JScrollPane archiveConsoleScrollPane;
    private JButton archiveStartRecoveryJButton;
    private JButton archivePauseRecoveryJButton;
    private JButton archiveStopRecoveryJButton;
    private JButton archiveChooserButton;
    private JButton sevenZChooserButton;
    private FileDialog programChooser;
    private FileDialog archiveChooser;
    private JTextField sevenZPathJTextField;
    private JTextField archiveJTextField;
    private JTextField passwordExcludeField;
    private JCheckBox passwordCheckBoxLowerCase;
    private JCheckBox passwordCheckBoxUpperCase;
    private JCheckBox passwordCheckBoxDigits;
    private JCheckBox passwordCheckBoxSpecial;
    private JSpinner minPasswordLengthSpinner;
    private JSpinner maxPasswordLengthSpinner;
    private JLabel characterChoiceLabel;
    private JLabel minPasswordLengthLabel;
    private JLabel blankLabel;
    private JLabel maxPasswordLengthLabel;
    private JLabel passwordExcludeLabel;
    private String sevenzLocation;
    private String archiveLocation;
    private ArchiveBruter archiveBruter;
    private Thread archiveBruterThread;
    private HashBruter hashBruter;
    private Thread hashBruterThread;
    private JPanel hashRecoveryPanel;
    private JPanel hashSouthJPanel;
    private JPanel hashSouthInnerRightJPanel;
    private JPanel hashNorthJPanel;
    private JPanel hashSouthInnerLeftJPanel;
    private JCheckBox hashCheckBoxDigits;
    private JCheckBox hashCheckBoxLowerCase;
    private JCheckBox hashCheckBoxSpecial;
    private JCheckBox hashCheckBoxUpperCase;
    private JButton hashStartRecoveryJButton;
    private JButton hashPauseRecoveryJButton;
    private JButton hashStopRecoveryJButton;
    private JTextField hashJTextField;
    private JLabel minHashLengthLabel;
    private JSpinner minHashLengthSpinner;
    private JTextField hashExcludeField;
    private JLabel maxHashLengthLabel;
    private JScrollPane hashConsoleScrollPane;
    private JTextArea hashConsoleJTextArea;
    private JSpinner maxHashLengthSpinner;
    private JLabel hashExcludeLabel;
    private JLabel hashLabel;
    private JTabbedPane tabbedPane;
    public static final String separtor;
    public static final String NEW_LINE = "\n";
    private String hash;
    private String hashType = "md5";
    private JComboBox hashTypeComboBox;
    private JLabel hashComboboxLabel;

    public BruterUI() {
        this.createGUI();
    }

    private void createGUI() {
        this.setTitle("OPORAVAK LOZINKE by STUDIO COBRA");
        this.setIconImage(new ImageIcon("resources" + separtor + "icon.png").getImage());
        this.setSize(800, 300);
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.addComponentsToContentPane(this.getContentPane());
        this.addAnonymousActionListeners();
        this.pack();
    }

    private void addComponentsToContentPane(Container contentPane) {
        this.readyComponents();
        this.menuFile.add(menuItemExit);
        this.menuHelp.add(menuItem7z);
        this.menuHelp.add(menuItemUpdate);
        this.menuHelp.add(menuItemAbout);
        this.menuBar.add(this.menuFile);
        this.menuBar.add(this.menuHelp);
        if (System.getProperty("os.name").contains("Windows")) {
            this.addArchiveComponentsToPanel();
            this.tabbedPane.insertTab("Oporavak lozinke komprimirane arhive", new ImageIcon("resources" + separtor + "compressed-archive.png"), this.archiveRecoveryPanel, "Omogu\u0107ava vam oporavak izgubljenih lozinki iz arhiva kao \u0161to su: .rar, .zip, .7z etc.", 0);
            this.addHashComponentsToPanel();
            this.tabbedPane.insertTab("MD5 and SHA-1/2 oporavak he\u0161a", new ImageIcon("resources" + separtor + "hash-icon.png"), this.hashRecoveryPanel, "Omogu\u0107ava vam oporavak izgubljenih lozinki iz MD5 i SHA-1 i SHA-2 he\u0161ova", 1);
        } else {
            this.addHashComponentsToPanel();
            this.tabbedPane.insertTab("MD5 and SHA-1/2 oporavak he\u0161a", new ImageIcon("resources" + separtor + "hash-icon.png"), this.hashRecoveryPanel, "Omogu\u0107ava vam oporavak izgubljenih lozinki iz MD5 i SHA-1 i SHA-2 he\u0161ova", 0);
        }
        contentPane.add((Component)this.menuBar, "North");
        contentPane.add(this.tabbedPane);
    }

    private void readyComponents() {
        this.prepareMenuBarAndSysTrayComponents();
        this.prepareArhiveRecoveryComponents();
        this.prepareHashRecoveryComponents();
    }

    private void prepareMenuBarAndSysTrayComponents() {
        this.trayIcon = new TrayIcon(new ImageIcon("resources/icon.png").getImage().getScaledInstance(16, 16, 1), "OPORAVAK LOZINKE BY STUDIO COBRA");
        if (!SystemTray.isSupported()) {
            JOptionPane.showMessageDialog(null, "Sistemska traka nije podr\u017eana", "Sistemska traka nije podr\u017eana!", 0);
        } else {
            this.tray = SystemTray.getSystemTray();
        }
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.menuHelp = new JMenu("Help");
        menuItemAbout = new JMenuItem("O nama", new ImageIcon(this.iconAbout));
        menuItemExit = new JMenuItem("Izlaz", new ImageIcon(this.iconExit));
        menuItemUpdate = new JMenuItem("Provjeri a\u017euriranja", new ImageIcon(this.iconUpdate));
        menuItem7z = new JMenuItem("Preuzmi 7-Zip", new ImageIcon(this.icon7z));
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("Datoteka");
        this.menuHelp = new JMenu("Pomo\u0107");
        menuItemAbout = new JMenuItem("O nama", new ImageIcon(this.iconAbout));
        menuItemExit = new JMenuItem("Izlaz", new ImageIcon(this.iconExit));
        menuItemUpdate = new JMenuItem("Provjeri a\u017euriranja", new ImageIcon(this.iconUpdate));
        menuItem7z = new JMenuItem("Preuzmi 7-Zip", new ImageIcon(this.icon7z));
        this.blankLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
    }

    private void prepareArhiveRecoveryComponents() {
        this.archiveRecoveryPanel = new JPanel(new BorderLayout(10, 10));
        this.archiveNorthJPanel = new JPanel(new GridLayout(2, 2));
        this.archiveSouthJPanel = new JPanel(new GridLayout(1, 2));
        this.archiveSouthInnerLeftJPanel = new JPanel();
        this.archiveSouthInnerRightJPanel = new JPanel(new GridLayout(8, 2));
        this.programChooser = new FileDialog((Frame)this, "7z.exe");
        this.archiveChooser = new FileDialog((Frame)this, "");
        this.passwordCheckBoxDigits = new JCheckBox("0-9");
        this.passwordCheckBoxLowerCase = new JCheckBox("a-z");
        this.passwordCheckBoxSpecial = new JCheckBox("~`!@#$%^&*()_-+=}]{[|\\\",/?>.<:;");
        this.passwordCheckBoxUpperCase = new JCheckBox("A-Z");
        this.archiveStartRecoveryJButton = new JButton("Zapo\u010dni oporavak");
        this.archivePauseRecoveryJButton = new JButton("Pauziraj oporavak");
        this.archiveStopRecoveryJButton = new JButton("Zaustavi oporavak");
        this.archiveChooserButton = new JButton("Pretra\u017ei arhivu (.7z, .zip, .rar)");
        this.sevenZChooserButton = new JButton("Pretra\u017eite za 7z.exe");
        this.sevenZPathJTextField = new JTextField("C:" + separtor + "Put" + separtor + "Do" + separtor + "7-Zip" + separtor + "7z.exe");
        this.archiveJTextField = new JTextField("C:" + separtor + "Put" + separtor + "Do" + separtor + "ziparchive" + separtor + "archive.*");
        this.sevenZPathJTextField.setEditable(false);
        this.archiveJTextField.setEditable(false);
        this.passwordExcludeField = new JTextField();
        this.passwordExcludeLabel = new JLabel("Isklju\u010di znakove:");
        this.minPasswordLengthLabel = new JLabel("Minimalna du\u017eina lozinke:");
        this.maxPasswordLengthLabel = new JLabel("Maksimalna du\u017eina lozinke:");
        this.characterChoiceLabel = new JLabel("Skupovi znakova:");
        this.minPasswordLengthSpinner = new JSpinner();
        this.maxPasswordLengthSpinner = new JSpinner();
        this.archiveConsoleJTextArea = new JTextArea(13, 30);
        this.archiveConsoleScrollPane = new JScrollPane(this.archiveConsoleJTextArea);
        this.passwordExcludeField.setToolTipText("Znakovi koji \u0107e biti isklju\u010deni iz trenutno odabranih skupova znakova i.e. ae1Q*");
        this.passwordExcludeLabel.setToolTipText("Znakovi koji \u0107e biti isklju\u010deni iz trenutno odabranih skupova znakova i.e ae1Q*");
        this.minPasswordLengthLabel.setToolTipText("Predstavlja du\u017einu na kojoj treba zapo\u010deti oporavak lozinke");
        this.maxPasswordLengthLabel.setToolTipText("Predstavlja du\u017einu na kojoj treba prekinuti poku\u0161aj oporavka");
        this.minPasswordLengthSpinner.setToolTipText("Predstavlja du\u017einu na kojoj treba zapo\u010deti oporavak lozinke");
        this.maxPasswordLengthSpinner.setToolTipText("Predstavlja du\u017einu na kojoj treba prekinuti poku\u0161aj oporavka");
        this.archiveStartRecoveryJButton.setToolTipText("Ovo \u0107e pokrenuti instancu i poku\u0161ati oporaviti lozinku uz ograni\u010denja.");
        this.archivePauseRecoveryJButton.setToolTipText("Ovo \u0107e pauzirati trenutnu instancu kako bi se smanjila upotreba procesora ako je potrebno");
        this.archiveStopRecoveryJButton.setToolTipText("Ovo \u0107e odmah zaustaviti trenutnu instancu oporavka");
        this.archiveChooserButton.setToolTipText("Omogu\u0107ava vam pregledavanje komprimirane arhive kako biste oporavili njenu lozinku");
        this.sevenZChooserButton.setToolTipText("Potra\u017eite lokaciju datoteke 7z.exe koja se nalazi u 7zips instalacijski direktorij");
        this.sevenZPathJTextField.setToolTipText("Lokacija datoteke 7z.exe koja se nalazi u direktoriju programa 7zip");
        this.archiveJTextField.setToolTipText("Putanja do arhive \u010dija se lozinka mora oporaviti");
        this.archivePauseRecoveryJButton.setEnabled(false);
        this.archiveStopRecoveryJButton.setEnabled(false);
        this.archiveConsoleJTextArea.setEditable(false);
        this.archiveConsoleJTextArea.setWrapStyleWord(true);
    }

    private void addArchiveComponentsToPanel() {
        this.archiveNorthJPanel.add(this.sevenZPathJTextField);
        this.archiveNorthJPanel.add(this.sevenZChooserButton);
        this.archiveNorthJPanel.add(this.archiveJTextField);
        this.archiveNorthJPanel.add(this.archiveChooserButton);
        this.archiveSouthInnerLeftJPanel.add(this.archiveConsoleScrollPane);
        this.archiveSouthInnerRightJPanel.add(this.characterChoiceLabel);
        this.archiveSouthInnerRightJPanel.add(this.blankLabel);
        this.archiveSouthInnerRightJPanel.add(this.passwordCheckBoxLowerCase);
        this.archiveSouthInnerRightJPanel.add(this.passwordCheckBoxUpperCase);
        this.archiveSouthInnerRightJPanel.add(this.passwordCheckBoxDigits);
        this.archiveSouthInnerRightJPanel.add(this.passwordCheckBoxSpecial);
        this.archiveSouthInnerRightJPanel.add(this.passwordExcludeLabel);
        this.archiveSouthInnerRightJPanel.add(this.passwordExcludeField);
        this.archiveSouthInnerRightJPanel.add(this.minPasswordLengthLabel);
        this.archiveSouthInnerRightJPanel.add(this.minPasswordLengthSpinner);
        this.archiveSouthInnerRightJPanel.add(this.maxPasswordLengthLabel);
        this.archiveSouthInnerRightJPanel.add(this.maxPasswordLengthSpinner);
        this.archiveSouthInnerRightJPanel.add(this.archiveStartRecoveryJButton);
        this.archiveSouthInnerRightJPanel.add(this.archivePauseRecoveryJButton);
        this.archiveSouthInnerRightJPanel.add(this.archiveStopRecoveryJButton);
        this.archiveSouthJPanel.add(this.archiveSouthInnerLeftJPanel);
        this.archiveSouthJPanel.add(this.archiveSouthInnerRightJPanel);
        this.archiveRecoveryPanel.add((Component)this.archiveNorthJPanel, "North");
        this.archiveRecoveryPanel.add((Component)this.archiveSouthJPanel, "South");
    }

    private void prepareHashRecoveryComponents() {
        this.hashRecoveryPanel = new JPanel(new BorderLayout(10, 10));
        this.hashNorthJPanel = new JPanel(new GridLayout(2, 1));
        this.hashSouthJPanel = new JPanel(new GridLayout(1, 2));
        this.hashSouthInnerLeftJPanel = new JPanel();
        this.hashSouthInnerRightJPanel = new JPanel(new GridLayout(9, 2));
        this.hashCheckBoxDigits = new JCheckBox("0-9");
        this.hashCheckBoxLowerCase = new JCheckBox("a-z");
        this.hashCheckBoxSpecial = new JCheckBox("~`!@#$%^&*()_-+=}]{[|\\\",/?>.<:;");
        this.hashCheckBoxUpperCase = new JCheckBox("A-Z");
        this.hashStartRecoveryJButton = new JButton("Zapo\u010dni oporavak");
        this.hashPauseRecoveryJButton = new JButton("Pauziraj oporavak");
        this.hashStopRecoveryJButton = new JButton("Zaustavi oporavak");
        this.hashJTextField = new JTextField("");
        this.hashExcludeField = new JTextField();
        this.hashExcludeLabel = new JLabel("Isklju\u010di znakove:");
        this.minHashLengthLabel = new JLabel("Minimalna du\u017eina he\u0161a:");
        this.maxHashLengthLabel = new JLabel("Maksimalna du\u017eina he\u0161a:");
        this.characterChoiceLabel = new JLabel("Skupovi znakova:");
        this.minHashLengthSpinner = new JSpinner();
        this.maxHashLengthSpinner = new JSpinner();
        this.hashLabel = new JLabel("Unesite he\u0161 ovdje");
        this.hashConsoleJTextArea = new JTextArea(13, 30);
        this.hashConsoleScrollPane = new JScrollPane(this.hashConsoleJTextArea);
        this.hashExcludeField.setToolTipText("Znakovi koji \u0107e biti isklju\u010deni iz trenutno odabranih skupova znakova i.e. ae1Q*");
        this.hashExcludeLabel.setToolTipText("Znakovi koji \u0107e biti isklju\u010deni iz trenutno odabranih skupova znakova i.e ae1Q*");
        this.minHashLengthLabel.setToolTipText("Predstavlja du\u017einu na kojoj treba zapo\u010deti oporavak he\u0161a");
        this.maxHashLengthLabel.setToolTipText("Predstavlja du\u017einu na kojoj se zaustavlja poku\u0161aj oporavka he\u0161a");
        this.minHashLengthSpinner.setToolTipText("Predstavlja du\u017einu na kojoj treba zapo\u010deti oporavak he\u0161a");
        this.maxHashLengthSpinner.setToolTipText("Predstavlja du\u017einu na kojoj se zaustavlja poku\u0161aj oporavka he\u0161a");
        this.hashStartRecoveryJButton.setToolTipText("Ovo \u0107e pokrenuti instancu i poku\u0161ati oporaviti he\u0161 pod ograni\u010denjima.");
        this.hashPauseRecoveryJButton.setToolTipText("Ovo \u0107e pauzirati trenutnu instancu kako bi se smanjila upotreba procesora ako je potrebno");
        this.hashStopRecoveryJButton.setToolTipText("Ovo \u0107e odmah zaustaviti trenutnu instancu oporavka he\u0161a");
        this.hashJTextField.setToolTipText("He\u0161 lozinke koji treba bruteforsirati za koliziju");
        this.hashPauseRecoveryJButton.setEnabled(false);
        this.hashStopRecoveryJButton.setEnabled(false);
        this.hashConsoleJTextArea.setEditable(false);
        this.hashConsoleJTextArea.setWrapStyleWord(true);
        String[] s = new String[]{"MD2", "MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512", "CRC16", "CRC32", "CRC64", "Adler32"};
        this.hashTypeComboBox = new JComboBox<String>(s);
        this.hashComboboxLabel = new JLabel("Vrsta he\u0161a");
    }

    private void addHashComponentsToPanel() {
        this.hashNorthJPanel.add(this.hashLabel);
        this.hashNorthJPanel.add(this.hashJTextField);
        this.hashSouthInnerLeftJPanel.add(this.hashConsoleScrollPane);
        this.hashSouthInnerRightJPanel.add(this.characterChoiceLabel);
        this.hashSouthInnerRightJPanel.add(this.blankLabel);
        this.hashSouthInnerRightJPanel.add(this.hashCheckBoxLowerCase);
        this.hashSouthInnerRightJPanel.add(this.hashCheckBoxUpperCase);
        this.hashSouthInnerRightJPanel.add(this.hashCheckBoxDigits);
        this.hashSouthInnerRightJPanel.add(this.hashCheckBoxSpecial);
        this.hashSouthInnerRightJPanel.add(this.hashComboboxLabel);
        this.hashSouthInnerRightJPanel.add(this.hashTypeComboBox);
        this.hashSouthInnerRightJPanel.add(this.hashExcludeLabel);
        this.hashSouthInnerRightJPanel.add(this.hashExcludeField);
        this.hashSouthInnerRightJPanel.add(this.minHashLengthLabel);
        this.hashSouthInnerRightJPanel.add(this.minHashLengthSpinner);
        this.hashSouthInnerRightJPanel.add(this.maxHashLengthLabel);
        this.hashSouthInnerRightJPanel.add(this.maxHashLengthSpinner);
        this.hashSouthInnerRightJPanel.add(this.hashStartRecoveryJButton);
        this.hashSouthInnerRightJPanel.add(this.hashPauseRecoveryJButton);
        this.hashSouthInnerRightJPanel.add(this.hashStopRecoveryJButton);
        this.hashSouthJPanel.add(this.hashSouthInnerLeftJPanel);
        this.hashSouthJPanel.add(this.hashSouthInnerRightJPanel);
        this.hashRecoveryPanel.add((Component)this.hashNorthJPanel, "North");
        this.hashRecoveryPanel.add((Component)this.hashSouthJPanel, "South");
    }

    private void addAnonymousActionListeners() {
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                int answer = JOptionPane.showConfirmDialog(null, "Jeste li sigurni da \u017eelite iza\u0107i?", "Izlaz", 0);
                if (0 == answer) {
                    if (isRunning) {
                        answer = JOptionPane.showConfirmDialog(null, "Oporavak je u toku, \u017eelite li ipak odustati?", "Upozorenje", 0);
                        if (0 == answer) {
                            BruterUI.this.archiveStopRecoveryJButton.doClick();
                            BruterUI.this.hashStopRecoveryJButton.doClick();
                            BruterUI.this.dispose();
                        } else if (1 == answer) {
                            // empty if block
                        }
                    } else {
                        BruterUI.this.dispose();
                    }
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
                int answer = JOptionPane.showConfirmDialog(null, "Minimizirati u sistemsku traku?", "Upozorenje", 0);
                if (0 == answer) {
                    try {
                        if (SystemTray.isSupported()) {
                            BruterUI.this.tray.add(BruterUI.this.trayIcon);
                            BruterUI.this.setVisible(false);
                        } else {
                            JOptionPane.showMessageDialog(null, "Va\u0161 operativni sistem ne podr\u017eava Java sistemsku traku", "Gre\u0161ka", 0);
                        }
                    }
                    catch (AWTException ex) {
                        JOptionPane.showMessageDialog(null, "Sistemska traka nije podr\u017eana", "Sistemska traka nije podr\u017eana!", 0);
                    }
                }
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.trayIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BruterUI.this.tray.remove(BruterUI.this.trayIcon);
                BruterUI.this.setVisible(true);
            }
        });
        menuItemUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = "https://studiocobra.net/index.php/kontakt";
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI(url));
                    }
                    catch (IOException | URISyntaxException ex) {
                        JOptionPane.showMessageDialog(null, "Do\u0161lo je do gre\u0161ke prilikom poku\u0161aja otvaranja URL-a za a\u017euriranje", "Gre\u0161ka", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Desktop nije podr\u017ean, molimo vas da posjetite: " + url + " za preuzimanje najnovije verzije.", "Upozorenje", 2);
                }
            }
        });
        menuItem7z.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI("http://www.7-zip.org/"));
                    }
                    catch (IOException | URISyntaxException ex) {
                        JOptionPane.showMessageDialog(null, "Do\u0161lo je do gre\u0161ke prilikom poku\u0161aja otvaranja URL-a www.7-zip.org", "Gre\u0161ka", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Desktop nije podr\u017ean, molimo vas da posjetite: http://www.7-zip.org/ za preuzimanje 7-Zip", "Upozorenje", 2);
                }
            }
        });
        menuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (isRunning) {
                    int answer = JOptionPane.showConfirmDialog(null, "Oporavak je u toku, \u017eelite li ipak odustati?", "Prekini dok je oporavak u toku...", 0);
                    if (answer == 0) {
                        BruterUI.this.archiveStopRecoveryJButton.doClick();
                        BruterUI.this.hashStopRecoveryJButton.doClick();
                        BruterUI.this.dispose();
                    }
                } else {
                    BruterUI.this.dispose();
                }
            }
        });
        menuItemAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        AboutBox aboutBox = new AboutBox();
                    }
                }).start();
            }
        });
        this.sevenZChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BruterUI.this.programChooser.setVisible(true);
                if (BruterUI.this.programChooser.getFile() != null && BruterUI.this.programChooser.getDirectory() != null) {
                    BruterUI.this.sevenzLocation = BruterUI.this.programChooser.getDirectory() + BruterUI.this.programChooser.getFile();
                    BruterUI.this.sevenZPathJTextField.setText(BruterUI.this.sevenzLocation);
                }
            }
        });
        this.archiveChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BruterUI.this.archiveChooser.setVisible(true);
                if (BruterUI.this.archiveChooser.getFile() != null && BruterUI.this.archiveChooser.getDirectory() != null) {
                    BruterUI.this.archiveLocation = BruterUI.this.archiveChooser.getDirectory() + BruterUI.this.archiveChooser.getFile();
                    BruterUI.this.archiveJTextField.setText(BruterUI.this.archiveLocation);
                }
            }
        });
        this.archiveStartRecoveryJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BruterUI.this.sevenzLocation == null || BruterUI.this.archiveLocation == null || BruterUI.this.archiveLocation.equals("") || BruterUI.this.sevenzLocation.equals("")) {
                    JOptionPane.showMessageDialog(null, "Niste odabrali putanju do 7z.exe datoteke i/ili zip arhiva nije odabrana", "Gre\u0161ka", 0);
                    return;
                }
                if ((Integer)BruterUI.this.minPasswordLengthSpinner.getValue() <= 0 || (Integer)BruterUI.this.maxPasswordLengthSpinner.getValue() <= 0) {
                    JOptionPane.showMessageDialog(null, "Molimo odaberite minimalnu i maksimalnu du\u017einu lozinke ve\u0107u od 0", "Gre\u0161ka", 0);
                    return;
                }
                if (!(BruterUI.this.passwordCheckBoxDigits.isSelected() || BruterUI.this.passwordCheckBoxUpperCase.isSelected() || BruterUI.this.passwordCheckBoxLowerCase.isSelected() || BruterUI.this.passwordCheckBoxSpecial.isSelected())) {
                    JOptionPane.showMessageDialog(null, "Molimo odaberite barem 1 skup znakova", "Gre\u0161ka", 0);
                    return;
                }
                if (isRunning) {
                    JOptionPane.showMessageDialog(null, "Instanca je ve\u0107 pokrenuta, molimo vas da je zaustavite, a zatim poku\u0161ate ponovo.", "Gre\u0161ka", 0);
                    return;
                }
                Runnable r = BruterUI.this.createArchiveThread();
                if (r == null) {
                    JOptionPane.showMessageDialog(null, "Do\u0161lo je do problema prilikom pokretanja instance. Mogu\u0107e je da je previ\u0161e znakova isklju\u010deno!", "Gre\u0161ka", 2);
                    return;
                }
                BruterUI.this.archiveBruterThread = new Thread(r);
                BruterUI.this.archiveBruterThread.start();
                Thread thread = new Thread(BruterUI.this.getStatus(BruterUI.this.archiveBruter));
                thread.start();
                isRunning = true;
                BruterUI.this.archivePauseRecoveryJButton.setEnabled(true);
                BruterUI.this.archiveStopRecoveryJButton.setEnabled(true);
            }
        });
        this.archivePauseRecoveryJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BruterUI.this.isPaused) {
                    BruterUI.this.archivePauseRecoveryJButton.setText("Poni\u0161ti pauzu u oporavku lozinke");
                    BruterUI.this.isPaused = true;
                    BruterUI.this.archiveBruter.setPaused(true);
                    BruterUI.this.archiveStartRecoveryJButton.setEnabled(false);
                } else {
                    BruterUI.this.archivePauseRecoveryJButton.setText("Pauziraj oporavak lozinke");
                    BruterUI.this.archiveBruter.setPaused(false);
                    BruterUI.this.isPaused = false;
                    BruterUI.this.archiveStartRecoveryJButton.setEnabled(true);
                }
            }
        });
        this.archiveStopRecoveryJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BruterUI.this.isPaused) {
                    BruterUI.this.archivePauseRecoveryJButton.doClick();
                }
                BruterUI.this.archivePauseRecoveryJButton.setEnabled(false);
                BruterUI.this.archiveStartRecoveryJButton.setEnabled(true);
                BruterUI.this.archiveBruter.setIsDone(true);
                isRunning = false;
                BruterUI.this.archiveBruter.setFound(true);
                BruterUI.this.clearPasswordText();
            }
        });
        this.hashStartRecoveryJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BruterUI.this.hash = BruterUI.this.hashJTextField.getText();
                if (BruterUI.this.hash.equals("")) {
                    JOptionPane.showMessageDialog(null, "Niste unijeli ispravan ha\u0161", "Gre\u0161ka", 0);
                    return;
                }
                if ((Integer)BruterUI.this.minHashLengthSpinner.getValue() <= 0 || (Integer)BruterUI.this.maxHashLengthSpinner.getValue() <= 0) {
                    JOptionPane.showMessageDialog(null, "Molimo odaberite minimalnu i maksimalnu du\u017einu he\u0161a ve\u0107u od 0", "Gre\u0161ka", 0);
                    return;
                }
                if (!(BruterUI.this.hashCheckBoxDigits.isSelected() || BruterUI.this.hashCheckBoxUpperCase.isSelected() || BruterUI.this.hashCheckBoxLowerCase.isSelected() || BruterUI.this.hashCheckBoxSpecial.isSelected())) {
                    JOptionPane.showMessageDialog(null, "Molimo odaberite barem 1 skup znakova", "Gre\u0161ka", 0);
                    return;
                }
                if (isRunning) {
                    JOptionPane.showMessageDialog(null, "Instanca je ve\u0107 pokrenuta, molimo vas da je zaustavite, a zatim poku\u0161ate ponovo.", "Gre\u0161ka", 0);
                    return;
                }
                Runnable r = BruterUI.this.createHashThread();
                if (r == null) {
                    JOptionPane.showMessageDialog(null, "Do\u0161lo je do problema prilikom pokretanja instance. Mogu\u0107e je da je previ\u0161e znakova isklju\u010deno!", "Gre\u0161ka", 2);
                    return;
                }
                BruterUI.this.hashBruterThread = new Thread(r);
                BruterUI.this.hashBruterThread.start();
                Thread thread = new Thread(BruterUI.this.getStatus(BruterUI.this.hashBruter));
                thread.start();
                isRunning = true;
                BruterUI.this.hashPauseRecoveryJButton.setEnabled(true);
                BruterUI.this.hashStopRecoveryJButton.setEnabled(true);
            }
        });
        this.hashPauseRecoveryJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BruterUI.this.isPaused) {
                    BruterUI.this.hashPauseRecoveryJButton.setText("Poni\u0161ti pauzu u oporavku he\u0161a");
                    BruterUI.this.isPaused = true;
                    BruterUI.this.hashBruter.setPaused(true);
                    BruterUI.this.hashStartRecoveryJButton.setEnabled(false);
                } else {
                    BruterUI.this.hashPauseRecoveryJButton.setText("Pauziraj oporavak he\u0161a");
                    BruterUI.this.hashBruter.setPaused(false);
                    BruterUI.this.isPaused = false;
                    BruterUI.this.hashStartRecoveryJButton.setEnabled(true);
                }
            }
        });
        this.hashStopRecoveryJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BruterUI.this.isPaused) {
                    BruterUI.this.hashPauseRecoveryJButton.doClick();
                }
                BruterUI.this.hashPauseRecoveryJButton.setEnabled(false);
                BruterUI.this.hashStopRecoveryJButton.setEnabled(false);
                BruterUI.this.hashStartRecoveryJButton.setEnabled(true);
                BruterUI.this.hashBruter.setIsDone(true);
                isRunning = false;
                BruterUI.this.hashBruter.setFound(true);
                BruterUI.this.clearHashText();
            }
        });
        this.hashTypeComboBox.addItemListener(new ItemListener(){
            int count = 0;

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (this.count == 0) {
                    ++this.count;
                } else if (this.count == 1) {
                    BruterUI.this.hashType = (String)BruterUI.this.hashTypeComboBox.getSelectedItem();
                    this.count = 0;
                }
            }
        });
    }

    private Runnable getStatus(Object o) {
        Runnable r = null;
        if (o instanceof ArchiveBruter) {
            r = new Runnable(){

                @Override
                public void run() {
                    while (!BruterUI.this.archiveBruter.isFound() & !BruterUI.this.archiveBruter.isDone()) {
                        if (!BruterUI.this.isPaused) {
                            BruterUI.this.clearPasswordText();
                            BruterUI.this.setPasswordText("Lozinka: " + BruterUI.this.archiveBruter.getGeneratedPassword());
                            if (BruterUI.this.archiveBruter.getGeneratedPassword() != null) {
                                BruterUI.this.setPasswordText("Du\u017eina lozinke: " + BruterUI.this.archiveBruter.getGeneratedPassword().length());
                            }
                            BruterUI.this.setPasswordText("Broj mogu\u0107nosti: " + BruterUI.this.archiveBruter.getNumberOfPossibilities());
                            BruterUI.this.setPasswordText("Procijenjeni broj preostalih lozinki: " + BruterUI.this.archiveBruter.getRemainder());
                            BruterUI.this.archiveBruter.setEndtime(System.nanoTime());
                            BruterUI.this.setPasswordText("Provjerene lozinke: " + BruterUI.this.archiveBruter.getCounter() + " @" + BruterUI.this.archiveBruter.getPerSecond() + "p.p.s");
                            BruterUI.this.setPasswordText("Proteklo vrijeme: " + BruterUI.this.archiveBruter.calculateTimeElapsed());
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                        }
                        if (BruterUI.this.archiveBruter.isFound() && BruterUI.this.archiveBruter.isDone()) {
                            isRunning = false;
                            BruterUI.this.archiveStopRecoveryJButton.setEnabled(false);
                            BruterUI.this.archivePauseRecoveryJButton.setEnabled(false);
                            BruterUI.this.clearPasswordText();
                            BruterUI.this.setPasswordText("Broj mogu\u0107nosti: " + BruterUI.this.archiveBruter.getNumberOfPossibilities());
                            BruterUI.this.setPasswordText("Du\u017eina lozinke: " + BruterUI.this.archiveBruter.getGeneratedPassword().length());
                            BruterUI.this.setPasswordText("Provjerene lozinke: " + BruterUI.this.archiveBruter.getCounter());
                            BruterUI.this.archiveBruter.setEndtime(System.nanoTime());
                            BruterUI.this.setPasswordText("Proteklo vrijeme: " + BruterUI.this.archiveBruter.calculateTimeElapsed());
                            BruterUI.this.setPasswordText("Prona\u0111ena lozinka: " + BruterUI.this.archiveBruter.getPassword());
                            continue;
                        }
                        if (!BruterUI.this.archiveBruter.isDone()) continue;
                        isRunning = false;
                        BruterUI.this.archiveStopRecoveryJButton.setEnabled(false);
                        BruterUI.this.archivePauseRecoveryJButton.setEnabled(false);
                        BruterUI.this.clearPasswordText();
                        BruterUI.this.setPasswordText("Broj mogu\u0107nosti: " + BruterUI.this.archiveBruter.getNumberOfPossibilities());
                        BruterUI.this.setPasswordText("Du\u017eina lozinke: " + BruterUI.this.archiveBruter.getGeneratedPassword().length());
                        BruterUI.this.setPasswordText("Provjerene lozinke: " + BruterUI.this.archiveBruter.getCounter());
                        BruterUI.this.archiveBruter.setEndtime(System.nanoTime());
                        BruterUI.this.setPasswordText("Proteklo vrijeme: " + BruterUI.this.archiveBruter.calculateTimeElapsed());
                        BruterUI.this.setPasswordText("Nisam mogao/mogla prona\u0107i nijednu lozinku izme\u0111u " + BruterUI.this.archiveBruter.getMinLength() + "-" + BruterUI.this.archiveBruter.getMaxLength());
                    }
                }
            };
        } else if (o instanceof HashBruter) {
            r = new Runnable(){

                @Override
                public void run() {
                    while (!BruterUI.this.hashBruter.isFound() & !BruterUI.this.hashBruter.isDone()) {
                        if (BruterUI.this.isPaused) continue;
                        BruterUI.this.clearHashText();
                        BruterUI.this.setHashText("Ha\u0161: " + BruterUI.this.hashBruter.getGeneratedHash());
                        BruterUI.this.setHashText("Broj mogu\u0107nosti: " + BruterUI.this.hashBruter.getNumberOfPossibilities());
                        if (BruterUI.this.hashBruter.getGeneratedHash() != null) {
                            BruterUI.this.setHashText("Du\u017eina znakova: " + BruterUI.this.hashBruter.getPassword().length());
                        }
                        BruterUI.this.hashBruter.setEndtime(System.nanoTime());
                        BruterUI.this.setHashText("Provjereni ha\u0161ovi: " + BruterUI.this.hashBruter.getCounter() + " @" + BruterUI.this.hashBruter.getPerSecond() + "h.p.s");
                        BruterUI.this.setHashText("Proteklo vrijeme: " + BruterUI.this.hashBruter.calculateTimeElapsed());
                        BruterUI.this.setHashText("Procijenjeni preostali ha\u0161evi: " + BruterUI.this.hashBruter.getRemainder());
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (BruterUI.this.hashBruter.isFound() && BruterUI.this.hashBruter.isDone()) {
                        BruterUI.this.hashStopRecoveryJButton.setEnabled(false);
                        BruterUI.this.hashPauseRecoveryJButton.setEnabled(false);
                        isRunning = false;
                        BruterUI.this.clearHashText();
                        BruterUI.this.setHashText("Broj mogu\u0107nosti: " + BruterUI.this.hashBruter.getNumberOfPossibilities());
                        BruterUI.this.setHashText("Du\u017eina znakova: " + BruterUI.this.hashBruter.getPassword().length());
                        BruterUI.this.setHashText("Provjereni ha\u0161ovi: " + BruterUI.this.hashBruter.getCounter());
                        BruterUI.this.hashBruter.setEndtime(System.nanoTime());
                        BruterUI.this.setHashText("Proteklo vrijeme: " + BruterUI.this.hashBruter.calculateTimeElapsed());
                        BruterUI.this.setHashText("Prona\u0111en podudaranje: " + BruterUI.this.hashBruter.getGeneratedHash() + " lozinka je: " + BruterUI.this.hashBruter.getPassword());
                    } else if (BruterUI.this.hashBruter.isDone()) {
                        isRunning = false;
                        BruterUI.this.hashStopRecoveryJButton.setEnabled(false);
                        BruterUI.this.hashPauseRecoveryJButton.setEnabled(false);
                        BruterUI.this.clearHashText();
                        BruterUI.this.setHashText("Broj mogu\u0107nosti: " + BruterUI.this.hashBruter.getNumberOfPossibilities());
                        BruterUI.this.setHashText("Du\u017eina znakova: " + BruterUI.this.hashBruter.getPassword().length());
                        BruterUI.this.setHashText("Provjereni ha\u0161ovi: " + BruterUI.this.hashBruter.getCounter());
                        BruterUI.this.hashBruter.setEndtime(System.nanoTime());
                        BruterUI.this.setHashText("Proteklo vrijeme: " + BruterUI.this.hashBruter.calculateTimeElapsed());
                        BruterUI.this.setHashText("Nisu prona\u0111eno nikakvo podudaranje izme\u0111u " + BruterUI.this.hashBruter.getMinLength() + "-" + BruterUI.this.hashBruter.getMaxLength());
                    }
                }
            };
        }
        return r;
    }

    private void checkArchiveCheckBoxes(Object o) {
        if (this.passwordCheckBoxDigits.isSelected()) {
            this.archiveBruter.addDigits();
        }
        if (this.passwordCheckBoxLowerCase.isSelected()) {
            this.archiveBruter.addLowerCaseLetters();
        }
        if (this.passwordCheckBoxUpperCase.isSelected()) {
            this.archiveBruter.addUpperCaseLetters();
        }
        if (this.passwordCheckBoxSpecial.isSelected()) {
            this.archiveBruter.addSpecialCharacters();
        }
    }

    private void checkHashCheckBoxes(Object o) {
        if (this.hashCheckBoxDigits.isSelected()) {
            this.hashBruter.addDigits();
        }
        if (this.hashCheckBoxLowerCase.isSelected()) {
            this.hashBruter.addLowerCaseLetters();
        }
        if (this.hashCheckBoxUpperCase.isSelected()) {
            this.hashBruter.addUpperCaseLetters();
        }
        if (this.hashCheckBoxSpecial.isSelected()) {
            this.hashBruter.addSpecialCharacters();
        }
    }

    private Runnable createArchiveThread() {
        Runnable r = null;
        this.archiveBruter = new ArchiveBruter();
        this.archiveBruter.set7zLocation(this.sevenzLocation);
        this.archiveBruter.setArchiveLocation(this.archiveLocation);
        this.archiveBruter.setMinLength((Integer)this.minPasswordLengthSpinner.getValue());
        this.archiveBruter.setMaxLength((Integer)this.maxPasswordLengthSpinner.getValue());
        this.checkArchiveCheckBoxes(this.archiveBruter);
        if (this.archiveBruter.excludeChars(this.passwordExcludeField.getText())) {
            r = new Runnable(){

                @Override
                public void run() {
                    BruterUI.this.archiveBruter.tryBruteForce();
                }
            };
        }
        return r;
    }

    private Runnable createHashThread() {
        Runnable r = null;
        this.hashBruter = new HashBruter();
        this.hashBruter.setHash(this.hash);
        this.hashBruter.setType(this.hashType);
        this.checkHashCheckBoxes(this.hashBruter);
        this.hashBruter.setMinLength((Integer)this.minHashLengthSpinner.getValue());
        this.hashBruter.setMaxLength((Integer)this.maxHashLengthSpinner.getValue());
        if (this.hashBruter.excludeChars(this.hashExcludeField.getText())) {
            r = new Runnable(){

                @Override
                public void run() {
                    BruterUI.this.hashBruter.tryBruteForce();
                }
            };
        }
        return r;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (System.getProperty("os.name").contains("Windows") && !this.isShown) {
            this.autodetect7z();
            this.isShown = true;
        }
    }

    private void autodetect7z() {
        String drive = System.getenv("homedrive") + separtor;
        boolean autoDetected = false;
        if (new File(drive + "Program Files (x86)" + separtor + "7-Zip" + separtor + "7z.exe").exists()) {
            autoDetected = true;
            this.sevenzLocation = drive + "Program Files (x86)" + separtor + "7-Zip" + separtor + "7z.exe";
            this.sevenZPathJTextField.setText(this.sevenzLocation);
        } else if (new File(drive + "7-Zip" + separtor + "7z.exe").exists()) {
            autoDetected = true;
            this.sevenzLocation = drive + "7-Zip" + separtor + "7z.exe";
            this.sevenZPathJTextField.setText(this.sevenzLocation);
        } else if (new File(drive + "Program Files" + separtor + "7-Zip" + separtor + "7z.exe").exists()) {
            autoDetected = true;
            this.sevenzLocation = drive + "Program Files" + separtor + "7-Zip" + separtor + "7z.exe";
            this.sevenZPathJTextField.setText(this.sevenzLocation);
        }
        if (autoDetected) {
            this.sevenZPathJTextField.setEnabled(false);
            this.sevenZChooserButton.setEnabled(false);
        } else {
            this.sevenZPathJTextField.setEnabled(false);
            JOptionPane.showMessageDialog(null, "7z.exe nije bilo mogu\u0107e prona\u0107i!\nDa dobijem 7-zip idi Pomo\u0107->Preuzmi 7-Zip", "Automatsko otkrivanje 7zip-a NIJE USPJELO", 0);
        }
    }

    void setPasswordText(String string) {
        String tmp = this.archiveConsoleJTextArea.getText();
        this.archiveConsoleJTextArea.setText(tmp + NEW_LINE + string);
    }

    void clearPasswordText() {
        this.archiveConsoleJTextArea.setText("");
    }

    void setHashText(String string) {
        String tmp = this.hashConsoleJTextArea.getText();
        this.hashConsoleJTextArea.setText(tmp + NEW_LINE + string);
    }

    void clearHashText() {
        this.hashConsoleJTextArea.setText("");
    }

    static {
        separtor = File.separator;
    }
}

