/*
 * Decompiled with CFR 0.152.
 */
package jpasswordrecoverytool;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import javax.swing.JOptionPane;
import jpasswordrecoverytool.Bruter;

public class HashBruter
extends Bruter {
    public String hash;
    public String generatedHash;
    public String password;
    public String type;
    private static final long POLY64REV = -2882303761517117440L;
    private static final long[] LOOKUPTABLE = new long[256];

    public String getType() {
        return this.type;
    }

    public String getPassword() {
        return this.password;
    }

    public void setHash(String p) {
        this.hash = p;
    }

    public void setType(String digestType) {
        this.type = digestType;
    }

    public String getGeneratedHash() {
        return this.generatedHash;
    }

    public void tryBruteForce() {
        this.starttime = System.nanoTime();
        for (int size = this.minLength; size <= this.maxLength && !this.found && !this.done; ++size) {
            while (this.paused) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            this.generateAllPossibleCombinations("", size);
        }
        this.done = true;
    }

    private void generateAllPossibleCombinations(String baseString, int length) {
        while (this.paused) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (!this.found || !this.done) {
            if (baseString.length() == length) {
                this.generatedHash = this.type.equalsIgnoreCase("crc32") ? this.generateCRC32(baseString) : (this.type.equalsIgnoreCase("adler32") ? this.generateAdler32(baseString) : (this.type.equalsIgnoreCase("crc16") ? this.generateCRC16(baseString) : (this.type.equalsIgnoreCase("crc64") ? HashBruter.generateCRC64(baseString.getBytes()) : this.generateHash(baseString.toCharArray()))));
                this.password = baseString;
                if (this.hash.equals(this.generatedHash)) {
                    this.password = baseString;
                    this.found = true;
                    this.done = true;
                }
                ++this.count;
            } else if (baseString.length() < length) {
                for (int n = 0; n < this.characters.size(); ++n) {
                    this.generateAllPossibleCombinations(baseString + (String)this.characters.get(n), length);
                }
            }
        }
    }

    private String generateHash(char[] passwordChar) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(this.type);
        }
        catch (NoSuchAlgorithmException e1) {
            JOptionPane.showMessageDialog(null, "Takav algoritam za he\u0161ove ne postoji", "Gre\u0161ka", 0);
        }
        String passwordString = new String(passwordChar);
        byte[] passwordByte = passwordString.getBytes();
        md.update(passwordByte, 0, passwordByte.length);
        byte[] encodedPassword = md.digest();
        String encodedPasswordInString = this.toHexString(encodedPassword);
        return encodedPasswordInString;
    }

    private void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        for (int i = 0; i < len; ++i) {
            this.byte2hex(block[i], buf);
        }
        return buf.toString();
    }

    private String generateCRC32(String baseString) {
        byte[] bytes = baseString.getBytes();
        CRC32 checksum = new CRC32();
        checksum.update(bytes, 0, bytes.length);
        return String.valueOf(checksum.getValue());
    }

    private String generateAdler32(String baseString) {
        byte[] bytes = baseString.getBytes();
        Adler32 checksum = new Adler32();
        checksum.update(bytes, 0, bytes.length);
        return String.valueOf(checksum.getValue());
    }

    private String generateCRC16(String baseString) {
        int[] table = new int[]{0, 49345, 49537, 320, 49921, 960, 640, 49729, 50689, 1728, 1920, 51009, 1280, 50625, 50305, 1088, 52225, 3264, 3456, 52545, 3840, 53185, 52865, 3648, 2560, 51905, 52097, 2880, 51457, 2496, 2176, 51265, 55297, 6336, 6528, 55617, 6912, 56257, 55937, 6720, 7680, 57025, 57217, 8000, 56577, 7616, 7296, 56385, 5120, 54465, 54657, 5440, 55041, 6080, 5760, 54849, 53761, 4800, 4992, 54081, 4352, 53697, 53377, 4160, 61441, 12480, 12672, 61761, 13056, 62401, 62081, 12864, 13824, 63169, 63361, 14144, 62721, 13760, 13440, 62529, 15360, 64705, 64897, 15680, 65281, 16320, 16000, 65089, 64001, 15040, 15232, 64321, 14592, 63937, 63617, 14400, 10240, 59585, 59777, 10560, 60161, 11200, 10880, 59969, 60929, 11968, 12160, 61249, 11520, 60865, 60545, 11328, 58369, 9408, 9600, 58689, 9984, 59329, 59009, 9792, 8704, 58049, 58241, 9024, 57601, 8640, 8320, 57409, 40961, 24768, 24960, 41281, 25344, 41921, 41601, 25152, 26112, 42689, 42881, 26432, 42241, 26048, 25728, 42049, 27648, 44225, 44417, 27968, 44801, 28608, 28288, 44609, 43521, 27328, 27520, 43841, 26880, 43457, 43137, 26688, 30720, 47297, 47489, 31040, 47873, 31680, 31360, 47681, 48641, 32448, 32640, 48961, 32000, 48577, 48257, 31808, 46081, 29888, 30080, 46401, 30464, 47041, 46721, 30272, 29184, 45761, 45953, 29504, 45313, 29120, 28800, 45121, 20480, 37057, 37249, 20800, 37633, 21440, 21120, 37441, 38401, 22208, 22400, 38721, 21760, 38337, 38017, 21568, 39937, 23744, 23936, 40257, 24320, 40897, 40577, 24128, 23040, 39617, 39809, 23360, 39169, 22976, 22656, 38977, 34817, 18624, 18816, 35137, 19200, 35777, 35457, 19008, 19968, 36545, 36737, 20288, 36097, 19904, 19584, 35905, 17408, 33985, 34177, 17728, 34561, 18368, 18048, 34369, 33281, 17088, 17280, 33601, 16640, 33217, 32897, 16448};
        byte[] bytes = baseString.getBytes();
        int crc = 0;
        for (byte b : bytes) {
            crc = crc >>> 8 ^ table[(crc ^ b) & 0xFF];
        }
        return Integer.toHexString(crc);
    }

    public static String generateCRC64(byte[] data) {
        long sum = 0L;
        for (int i = 0; i < data.length; ++i) {
            int lookupidx = ((int)sum ^ data[i]) & 0xFF;
            sum = sum >>> 8 ^ LOOKUPTABLE[lookupidx];
        }
        return String.valueOf(sum);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            long v = i;
            for (int j = 0; j < 8; ++j) {
                if ((v & 1L) == 1L) {
                    v = v >>> 1 ^ 0xD800000000000000L;
                    continue;
                }
                v >>>= 1;
            }
            HashBruter.LOOKUPTABLE[i] = v;
        }
    }
}

